﻿var panelCommon = {
    container: null,
    panelDataService: null,
    hasCustomExport: $('.HasCustomExport').val() == "True",
    autoCompleteData: [],
}

$(document).ready(function () {
    panelCommon.container = ($("#main").length > 0) ? $("#main") : $(".modernEditor");

    $(".expandable > :first-child", panelCommon.container).on("click", function () {
        var container = $(this).parent();
        ToggleExpand(this, $(this).next(), panelCommon.container, container.attr("data-expandable"));
    });

    BindValidationOnSave();
});

function BindValidationOnSave() {
    $(".validateForm").on("click", function (event) {
        var content = $(this).closest(".modernEditor");

        $(".required:visible", content).each(function (index, item) {
            var requiredElement = $(item);
            var value;
            if (!requiredElement.is("input")) {
                input = $("input", requiredElement);
                if (input.is("[type=radio]")) {
                    value = $("input:radio:checked", requiredElement).val();
                }
            }

            if (!value) {
                value = requiredElement.val();
            }

            if (!value || value.length == 0) {
                $(".requiredErrorMessage", $(item).parent()).show(1000);
                event.preventDefault();
            }
            else {
                $(".requiredErrorMessage", $(item).parent()).hide();
            }
        });
    });
}

function ToggleExpand(header, content, configuration, setting) {
    $(content).toggle();
    $(".fa", header).toggleClass("fa-caret-down fa-caret-right");
    $(".imgHideSection,.imgDisplaySection", header).toggleClass("imgHideSection imgDisplaySection");

    if ($(content).is(":visible")) {
        $(header).attr("title", sharedResources.Collapse);
    }
    else {
        $(header).attr("title", sharedResources.Expand);
    }
}

function GetCurrentPagePath() {
    var pathName = window.location.pathname;
    return pathName.substring(pathName.lastIndexOf('/') + 1);
}

function ExportPanelists(filter, sampleId, selectedPanelistIds) {
    if (panelCommon.hasCustomExport)
        modalDialog.showWindow(a4.getAction("ExportPanelists", "Panelists", "Panel", { SampleId: sampleId }), 250, 600);
    else {
        a4.showBusyBox();
        var params = { "filterDef": JSON.stringify(filter), "sampleId": sampleId, "selectedPanelistIds": selectedPanelistIds };

        a4.callServerMethod(a4.getAction("CreatePanelistExportTask", "Panelists", "Panel"), params, function (result) {
            a4.parent().location.assign(a4.getAction("Index", "PanelistExportations", "Panel"));
        }, null, {
            complete: function (jqXHR, textStatus) {
                if (textStatus == "timeout") {
                    a4.showErrorMessage(resources.TimeoutErrorMessage);
                }
            }
        });
    }
}

function SyncExportPanelists(filter, sampleId, selectedPanelistIds) {
    if (panelCommon.hasCustomExport)
        modalDialog.showWindow(a4.getAction("ExportPanelists", "Panelists", "Panel", { SampleId: sampleId }), 250, 600);
    else {
        a4.showBusyBox();
        var params = { "filterDef": JSON.stringify(filter), "sampleId": sampleId, "selectedPanelistIds": selectedPanelistIds };

        a4.callServerMethod(a4.getAction("GeneratePanelistExportFile", "Panelists", "Panel"), params,
            function (result) {
                if (result != null && result.length > 0) {
                    var src = a4.getAction("ExportPanelists", "Panelists", "Panel", { GetFile: result, SampleId: sampleId });
                    a4.hideBusyBox();
                    a4.parent().location.replace(src);
                }
            },
            function () {
                a4.hideBusyBox();
            },
            {
                complete: function (jqXHR, textStatus) {
                    if (textStatus == "timeout") {
                        a4.showErrorMessage(resources.TimeoutErrorMessage);
                    }
                }
            });
    }
}